% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{intervention.tfm}
\alias{intervention.tfm}
\alias{intervention}
\alias{intervention.um}
\title{Intervention analysis/Outlier treatment}
\usage{
\method{intervention}{tfm}(
  mdl,
  y = NULL,
  type,
  time,
  n.ahead = 0,
  envir = parent.frame(),
  ...
)

intervention(mdl, ...)

\method{intervention}{um}(
  mdl,
  y = NULL,
  type,
  time,
  n.ahead = 0,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{y}{a "ts" object, optional.}

\item{type}{the type intervention (pulse, step, ramp) or the type of outlier
(AO, LS, TC, IO).}

\item{time}{the date of the intervention, in format c(year, season).}

\item{n.ahead}{a positive integer to extend the sample period of the
intervention variable with \code{n.ahead} observations, which could be
necessary to forecast the output.}

\item{envir}{the environment in which to look for the time series z when it
is passed as a character string.}

\item{...}{additional arguments.}
}
\value{
an object of class "\code{\link{tfm}}" or a table.
}
\description{
\code{intervention} estimates the effect of a intervention at a known time.
}
