% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounders.ext.R
\name{confounders.ext}
\alias{confounders.ext}
\title{Sensitivity analysis for unmeasured confounders based on external adjustment}
\usage{
confounders.ext(RR, bias_parms = NULL)
}
\arguments{
\item{RR}{"True" or fully adjusted exposure relative risk.}

\item{bias_parms}{Numeric vector defining the necessary bias parameters. This
vector has 4 elements, in the following order:
\enumerate{
\item the association between the confounder and the outcome (RR, relative risk),
\item the association between exposure category and the confounder (OR, odds ratio),
\item the prevalence of the confounder (between 0 and 1), and
\item the prevalence of the exposure (between 0 and 1).
}}
}
\value{
A list with elements:
\item{model}{Bias analysis performed.}
\item{bias_parms}{Input bias parameters.}
\item{adj_measures}{Output results, with bias as a percentage: (crude_RR - RR)/RR * 100.}
}
\description{
Sensitivity analysis to explore effect of residual confounding using simple
algebraic transformation. It provides the relative risk adjusted for unmeasured
confounders based on available external information (i.e. from the literature) on
the relation between confounders and outcome.
}
\examples{
# Schneeweiss, S, Glynn, R.J., Tsai, E.H., Avorn, J., Solomon, D.H. Adjusting for
# unmeasured confounders in pharmacoepidemiologic claims data using external
# information. Epidemiology 2005; 16: 17-24.
confounders.ext(RR = 1, bias_parms = c(0.1, 0.9, 0.1, 0.4))
}
\references{
Schneeweiss, S., 2006. Sensitivity analysis and external adjustment for
unmeasured confounders in epidemiologic database studies of therapeutics.
\emph{Pharmacoepidemiol Drug Safety} 15: 291-303.
}
\seealso{
Other confounding: 
\code{\link{confounders}()},
\code{\link{confounders.array}()},
\code{\link{confounders.evalue}()},
\code{\link{confounders.limit}()},
\code{\link{probsens.irr.conf}()}
}
\concept{confounding}
