% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.svemnet.R
\name{plot.svem_binomial}
\alias{plot.svem_binomial}
\title{Plot Method for SVEM Binomial Models}
\usage{
\method{plot}{svem_binomial}(
  x,
  type = c("calibration", "roc", "pr"),
  bins = 10,
  jitter_width = 0.05,
  ...
)
}
\arguments{
\item{x}{An object of class \code{svem_binomial}.}

\item{type}{One of \code{"calibration"}, \code{"roc"}, or \code{"pr"} (default \code{"calibration"}).}

\item{bins}{Integer number of equal-frequency bins for calibration (default \code{10}).}

\item{jitter_width}{Vertical jitter amplitude for raw points in calibration (default \code{0.05}).}

\item{...}{Additional aesthetics passed to \code{ggplot2::geom_line()} or \code{ggplot2::geom_point()}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Diagnostics for \code{svem_binomial} fits from \code{SVEMnet(..., family = "binomial")}.
Produces one of:
\itemize{
\item \code{type = "calibration"}: Reliability curve (binned average predicted probability vs observed rate),
with jittered raw points for context.
\item \code{type = "roc"}: ROC curve with trapezoidal AUC in the title.
\item \code{type = "pr"}: Precision–Recall curve with step-wise Average Precision (AP).
}
}
\details{
For ROC/PR, simple one-class guards are used (returns a diagonal ROC and trivial PR).
The function assumes binomial models store \code{x$y_pred} on the \emph{probability} scale.
}
\examples{
\dontrun{
  ## --- Binomial example: simulate, fit, and plot --------------------------
  set.seed(2025)
  n  <- 600
  x1 <- rnorm(n); x2 <- rnorm(n); x3 <- rnorm(n)
  eta    <- -0.4 + 1.1*x1 - 0.8*x2 + 0.5*x3
  p_true <- plogis(eta)
  y      <- rbinom(n, 1, p_true)
  dat_b  <- data.frame(y, x1, x2, x3)

  fit_b <- SVEMnet(
    y ~ x1 + x2 + x3 + I(x1^2) + (x1 + x2 + x3)^2,
    data          = dat_b,
    family        = "binomial",
    glmnet_alpha  = c(1, 0.5),
    nBoot         = 60,
    objective     = "auto",
    weight_scheme = "SVEM",
    relaxed       = TRUE
  )

  # Calibration / ROC / PR
  plot(fit_b, type = "calibration", bins = 12)
  plot(fit_b, type = "roc")
  plot(fit_b, type = "pr")
}

}
