% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tssa.R
\name{print.tssa}
\alias{print.tssa}
\title{Semantric Structure Analysis Print}
\usage{
\method{print}{tssa}(x, digits = 3, ...)
}
\arguments{
\item{x}{requires the result object of hssr function}

\item{digits}{integer indicating the number of decimal places to be used}

\item{...}{further arguments passed to or from other methods}
}
\description{
\code{print} function for the \code{tssa} object
}
\details{
Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA) are graphical approaches
}
\examples{
# Example data based on Takeya (1991)

# Takea Semantic Structure Analysis
# ordering assesed according to the ordering coefficient
exdat.tssa <- TSSA(exdat, m = 5, output = FALSE)
print(exdat.tssa)

# Takea Semantic Structure Analysis including statistical testing
# ordering assesed according to the ordering coefficient and statistical significance
exdat.tssa <- TSSA(exdat, m = 5, sig = TRUE, output = FALSE)
print(exdat.tssa)
}
\author{
Takuya Yanagida
Keiko Sakai
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{seqtable}}
}

