% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ssra.R
\name{plot.ssra}
\alias{plot.ssra}
\title{Plot ssra}
\usage{
\method{plot}{ssra}(x, r.crt = NULL, r.sig = TRUE, d.sq = NULL,
  m.sig = TRUE, sig.col = TRUE, col = c("red2", "green4", "blue3",
  "black"), pch = c(1, 2, 0, 4), mar = c(3.5, 3.5, 1.5, 1), ...)
}
\arguments{
\item{x}{requires the return object from the SSRA function}

\item{r.crt}{minimal absolute correlation to be judged 'sequential'}

\item{r.sig}{plot statistically significant correlations}

\item{d.sq}{minimal effect size Cohen's d to be judged 'sequential'}

\item{m.sig}{plot statistically significant mean difference}

\item{sig.col}{significance in different colors}

\item{col}{color code or name}

\item{pch}{plotting character}

\item{mar}{number of lines of margin to be specified on the four sides of the plot}

\item{...}{further arguments passed to or from other methods}
}
\description{
Function for plotting the ssra object
}
\details{
Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA) are graphical approaches
}
\examples{
\dontrun{
# Example data based on Takeya (1991)

# Sakai Sequential Relation Analysis
# ordering assesed according to the correlation coefficient and mean difference
exdat.ssra <- SSRA(exdat, output = FALSE)
plot(exdat.ssra)
}
}
\author{
Takuya Yanagida
Keiko Sakai
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{SSRA}}, \code{\link{treegram}}, \code{\link{scatterplot}}
}

