\name{summary.samur}
\alias{summary.samur}
\alias{print.summary.samur}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Summarizing Output of SAMUR Augmentation Function
}
\description{
\code{summary} method for class "samur".
}
\usage{
\method{summary}{samur}(object, ...)
\method{print}{summary.samur}(x, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{An object of class "samur", usually the result of a call to \code{\link{samur}}.}
  \item{x}{An object of class "summary.samur", usually the result of a call to \code{summary.samur}.}
  \item{...}{Further arguments to be passed to/from other methods. Current implementation of \code{summary.samur} passes arguments to \code{MatchBalance} function from \code{Matching} package.}
}
\value{
A list with the following elements:
  \item{min.pval.new}{A vector of length equal to number of samples (\code{nsmp}) generated by \code{\link{samur}}, each representing the minimum p-value from all univariate tests performed by the underlying function \code{\link[Matching]{MatchBalance}}. It also has an attributed named \code{min.pval.orig}, containing a similar number for the original matched subset, i.e. \code{data[matched.subset, ]}.}
  \item{min.pval.orig}{Same number as above, but for original matched subset.}
  \item{coverage.new}{Percent of cases from full data set covered among all stochastic, matched samples.}
  \item{coverage.orig}{Same as above, calculated for the original matched subset.}
}

\note{
All t-tests used for p-value calculations are "not" paired, since the philosophy of stochastic augmentation relaxes the notion of one-to-one matching.
}

\author{Alireza S. Mahani, Mansour T.A. Sharabiani}

\seealso{
\code{\link{samur}}, \code{\link[Matching]{MatchBalance}}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.

