% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary.segmentation.R
\name{binary.segmentation}
\alias{binary.segmentation}
\title{Segmentation Procedure for Binary Images}
\usage{
binary.segmentation(
  x,
  id,
  filter = NA,
  k = 3,
  categories = c("none", "geometric", "boundary", "topological")
)
}
\arguments{
\item{x}{a binary matrix that represents the reconstructed image.}

\item{id}{a named character vector that contains the ID's pertaining to the sample.}

\item{filter}{an integer vector that indicates the filtering procedure.}

\item{k}{an integer that specifies the factor to enlarge the regions.}

\item{categories}{a character string or vector, see \code{\link{compute.features}}.}
}
\value{
A \code{list} object whose components are the following:
\itemize{
\item \code{desc}:       a \code{data.frame} of the shape features
corresponding to each segmented ROI;
\item \code{holes}:      an integer matrix that contains the holes within
each ROI, labeled according to
the \code{regions};
\item \code{id}:         a character vector that is identical to the
\code{id} argument passed;
\item \code{k}:          argument \code{k} passed to function;
\item \code{n}:          an integer that indicates the number of
segmented regions;
\item \code{plg.chains}: a \code{list} where each component is the
polygonal chain of a segmented ROI;
\item \code{regions}:    an integer matrix that contains the segmented
ROI, labeled from largest to smallest.
}
}
\description{
Identify and segment the regions of interest (ROI) in a reconstructed binary
image, while having the option to extract quantitative shape-based features.
}
\details{
The argument \code{id} specifies the ID's corresponding to the sample.
A usual example that is used if the argument is an unnamed vector is composed
of the following entries:
\itemize{
\item \code{cohort}: name of cohort the sample belongs to;
\item \code{patient.id}: unique identifier for patient the sample belongs to;
\item \code{slide.id}: unique identifier for sample.
}

The argument \code{filter} specifies how the ROI should be filtered. There
are two ways to filter them, either by only specifying a minimum net area or
by additionally specifying the \eqn{n} largest regions to keep in a two element
vector. The default value is \code{NA} which sets the minimum net area as
one-fourth the largest region.

The argument \code{categories} specifies the shape features to compute. The
default is "none" which computes no features.
}
\section{Reconstructed Binary Image}{


To produce a reconstructed binary image, a greyscale scan or an image easily
converted to binary, resulting from different modalities, is converted
to a matrix representation, usually by standard image processing algorithms.

The resulting matrix is composed of two integer values that help represent the
regions of interest in the scan. Usually, as in the case of pathology
imaging, these are empty regions and tumor tissues, where we refer to the
integer values as categories. We note that the regions of interest must be
represented by \code{1}'s and what we consider the empty regions by \code{0}'s.
}

\examples{
# load libraries
library(SAFARI)

# load sample
data("rBPS")

# segmentation procedure
rBPS <- binary.segmentation(
    rBPS,
    id = c("NLST", "AA00474", "11030"),
    filter = 150,
    categories = c("geometric", "boundary", "topological")
)
}
