% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{saf_from_gff3}
\alias{saf_from_gff3}
\title{Creates a SAF file from a GFF3 for the given pairs of blocks and features,
note that groupBy and block vectors must have the same length}
\usage{
saf_from_gff3(
  gffFile,
  outFile,
  forceOverwrite = FALSE,
  features = c("gene > exon"),
  sep = ">"
)
}
\arguments{
\item{gffFile}{Path to the input GFF file}

\item{outFile}{Path to the output SAF file,  if not provided the output path will be the input path (without extension) with the suffix ".groupBy1-block1.groupBy2-block2(...).saf"}

\item{forceOverwrite}{If output file exists, overwrite the existing file. (default FALSE)}

\item{features}{Vector of pairs of features, separated by '>' (see sep argument), to be used respectively as "group by" and "block"}

\item{sep}{Separator of each "group by" and "block" provided in the feature argument (default '>')}
}
\value{
Path to the generated SAF file
}
\description{
This function creates a SAF file from a GFF3 for the given blocks
and features
}
\keyword{internal}
