% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vamp_functions.R
\name{vampPluginParams}
\alias{vampPluginParams}
\title{Get Parameters for a Specific Vamp Plugin}
\usage{
vampPluginParams(key)
}
\arguments{
\item{key}{Character string specifying the plugin key in "library:plugin" format
(e.g., "vamp-aubio-plugins:aubionotes"). Use \code{\link{vampPlugins}} to
get plugin IDs.}
}
\value{
A data frame with one row per parameter and columns including:
\describe{
\item{identifier}{Parameter identifier}
\item{name}{Human-readable parameter name}
\item{description}{Parameter description}
\item{unit}{Unit of measurement (if applicable)}
\item{min_value}{Minimum allowed value}
\item{max_value}{Maximum allowed value}
\item{default_value}{Default value}
\item{quantized}{Logical indicating if parameter is quantized to discrete values}
}
Returns an empty data frame if the plugin has no configurable parameters.
}
\description{
Returns detailed information about the configurable parameters for a given
Vamp plugin. Parameters can be adjusted to customize plugin behavior.
}
\examples{
\dontrun{
# Get parameters for aubio onset detector
params <- vampPluginParams("vamp-aubio-plugins:aubioonset")
}
}
\seealso{
\code{\link{vampPlugins}} to list available plugins
}
