% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orphanet.R
\name{downloadOrphanet}
\alias{downloadOrphanet}
\title{Download Orphanet to assist with adding synonyms for rare diseases}
\usage{
downloadOrphanet(
  orphanet_url =
    "https://www.orphadata.com/data/nomenclature/packs/Orphanet_Nomenclature_Pack_EN.zip",
  masterfile_name = NULL,
  SNOMED = getSNOMED()
)
}
\arguments{
\item{orphanet_url}{URL or filepath to Orphanet zip file}

\item{masterfile_name}{name of xls file containing Orphanet synonyms.
If omitted, it is assumed to be the only file with 'MasterFile'
in its name, and the program will search for it in the Orphanet
zip file.}

\item{SNOMED}{environment containing SNOMED CT dictionary}
}
\value{
data.table containing Orphanet synonyms in the format
}
\description{
Downloads the Orphanet nomenclature pack and converts it into a
format to be appended to MANUAL_SYNONYMS and used in concept
database creation.
}
\examples{
# Not run
# ORPHANET <- downloadOrphanet()
}
\references{
\url{https://www.orphadata.com/pack-nomenclature/}
}
\seealso{
downloadWordnet, MANUAL_SYNONYMS

Other CDB functions: 
\code{\link{addComposeLookupToCDB}()},
\code{\link{addWordnet}()},
\code{\link{batchDecompose}()},
\code{\link{createCDB}()},
\code{\link{downloadWordnet}()}
}
\concept{CDB functions}
