% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{createTransitive}
\alias{createTransitive}
\title{Create a transitive closure table for is-a relationships for
faster ancestor / descendant lookups}
\usage{
createTransitive(
  conceptIds,
  SNOMED = getSNOMED(),
  tables = c("RELATIONSHIP", "STATEDRELATIONSHIP")
)
}
\arguments{
\item{conceptIds}{character or integer64 vector of SNOMED concept IDs
for the subset of concepts to include in the transitive table.}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{tables}{vector of names of relationship table(s) to use;
by default use both RELATIONSHIP and STATEDRELATIONSHIP}
}
\description{
Returns a data.table containing ancestor / descendant relationships
which can be used in ancestors and descendants functions
}
\examples{
SNOMED <- sampleSNOMED()

TRANSITIVE <- createTransitive('Heart failure')
}
\seealso{
[ancestors()] and [descendants()]
}
