% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARCOS.R
\name{apply.MARCOS}
\alias{apply.MARCOS}
\title{Apply Measurement of Alternatives and Ranking according to Compromise Solution (MARCOS)}
\usage{
apply.MARCOS(mat, weights, beneficial.vector)
}
\arguments{
\item{mat}{is a matrix and contains the values for different properties
of different alternatives.}

\item{weights}{are the weights of each property in the decision-making process.}

\item{beneficial.vector}{is a vector that contains the column number of beneficial
properties.}
}
\value{
a vector containing the aggregated appraisal scores.
}
\description{
Apply Measurement of Alternatives and Ranking according to Compromise Solution (MARCOS)
}
\examples{

mat <- matrix(c(660, 1000, 1600, 18, 1200,
                800, 1000, 1600, 24, 900,
                980, 1000, 2500, 24, 900,
                920, 1500, 1600, 24, 900,
                1380, 1500, 1500, 24, 1150,
                1230, 1000, 1600, 24, 1150,
                680, 1500, 1600, 18, 1100,
                960, 2000, 1600, 12, 1150), nrow = 8, byrow = TRUE)
weights <- c(0.1061, 0.3476, 0.3330, 0.1185, 0.0949)
beneficial.vector <- c(2, 3, 4, 5)  # Columns 2, 3, 4, and 5 are beneficial
apply.MARCOS(mat, weights, beneficial.vector)
}
