% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{pqcor_fig}
\alias{pqcor_fig}
\title{Providing correlations between price and quantity of sold products}
\usage{
pqcor_fig(data, start, end, figure = TRUE, date_breaks = "1 month", set = c())
}
\arguments{
\item{data}{The user's data frame. It must contain columns: \code{time} (as Date in format: year-month-day, e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities} (as positive numeric) and \code{prodID} (as numeric, factor or character) with unique product IDs.}

\item{start}{The beginning of the considered time interval (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The end of the considered time interval (as character) limited to the year and month, e.g. "2020-04".}

\item{figure}{A logical parameter indicating whether the function returns a figure (TRUE) or a data frame (FALSE) with price-quantity correlations.}

\item{date_breaks}{A string giving the distance between breaks on the X axis like "1 month" (default value) or "4 months".}

\item{set}{The set of unique product IDs to be used for determining correlation between prices and quantities of sold products (see also \code{\link{data_matching}}). If the \code{set} is empty, the function works for all products being available in \code{period}.}
}
\value{
The function returns Pearson's correlation coefficients between price and quantity of products with given IDs and sold in the time interval: \code{<start, end>}. Correlation coefficients are calculated for each month separately. Results are presented in tabular or graphical form depending on the \code{figure} parameter.
}
\description{
The function returns Pearson's correlation coefficients between price and quantity of sold products with given IDs.
}
\examples{
\donttest{pqcor_fig(milk, start="2018-12", end="2019-12", figure=FALSE)}
\donttest{pqcor_fig(milk, start="2018-12", end="2019-12", figure=TRUE)}
}
