#' Panel Count Models with Random Effects and/or Sample Selection
#' @description  A high performance package for estimating panel count models with random effects and/or sample selection. \cr
#' @section Functions:
#' ProbitRE: Probit model with random effects on individuals \cr \cr
#' PoissonRE: Poisson model with random effects on individuals \cr \cr
#' PLN_RE: Poisson Lognormal model with random effects on individuals \cr \cr
#' ProbitRE_PoissonRE: PoissonRE and ProbitRE model with correlated random effects on individuals \cr \cr
#' ProbitRE_PLNRE: PLN_RE and ProbitRE model with correlated random effects on individual level and correlated error terms on individual-time level \cr \cr
#' @name PanelCount
#' @importFrom statmod gauss.quad
#' @importFrom Rcpp evalCpp
#' @importFrom stats binomial pnorm dnorm qnorm plogis dlogis poisson dpois glm model.frame model.matrix model.response optim pchisq
#' @importFrom utils head tail
#' @importFrom MASS mvrnorm
#' @useDynLib PanelCount
#' @references
#' 1. Peng, J., & Van den Bulte, C. (2023). Participation vs. Effectiveness in Sponsored Tweet Campaigns: A Quality-Quantity Conundrum. Management Science (forthcoming). Available at SSRN: <https://www.ssrn.com/abstract=2702053>
#'
#' 2. Peng, J., & Van den Bulte, C. (2015). How to Better Target and Incent Paid Endorsers in Social Advertising Campaigns: A Field Experiment. 2015 International Conference on Information Systems. <https://aisel.aisnet.org/icis2015/proceedings/SocialMedia/24/>
NULL
'_PACKAGE'