% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRDA-package.R
\docType{package}
\name{PRDA-package}
\alias{PRDA}
\alias{PRDA-package}
\title{PRDA: Prospective and Retrospective Design Analysis.}
\description{
Given an hypothetical value of effect size, \pkg{PRDA} performs a prospective
or retrospective design analysis to evaluate the inferential risks (i.e.,
power, Type M error, and Type S error) related to the study design. See
\code{vignette("PRDA")} for a brief introduction to \emph{Design
Analysis}.
}
\details{
PRDA package can be used for Pearson's correlation between two variables
or mean comparisons (i.e., one-sample, paired, two-sample, and Welch's
t-test) considering an hypothetical value of \eqn{\rho} or Cohen's \emph{d}
respectively. See \code{vignette("retrospective")} for more details.
}
\section{Functions}{

In \pkg{PRDA} there are two main functions:
\itemize{
\item{\strong{\code{retrospective()}}}. Given the hypothetical population
effect size and the study sample size, the function \code{retrospective()}
performs a retrospective design analysis. According to the defined
alternative hypothesis and the significance level, the inferential risks
(i.e., Power level, Type M error, and Type S error) are computed together
with the critical effect value (i.e., the minimum absolute effect size value
that would result significant). To know more about function arguments and
examples see the function documentation
\code{\link[PRDA:retrospective]{?retrospective}} and
\code{vignette("retrospective")}.

\item{\strong{\code{prospective()}}}. Given the hypothetical population
effect size and the required power level, the function \code{prospective()}
performs a prospective design analysis. According to the defined alternative
hypothesis and the significance level, the required sample size is computed
together with the associated Type M error, Type S error, and the critical
effect value (i.e., the minimum absolute effect size value that would
result significant).  To know more about function arguments and examples see
the function documentation \code{\link[PRDA:prospective]{?prospective}}
and \code{vignette("prospective")}.
}
}

\section{Hypothetical Effect Size}{

The hypothetical population effect size can be defined as a single value
according to previous results in the literature or experts indications.
Alternatively, \pkg{PRDA} allows users to specify a distribution of plausible
values to account for their uncertainty about the hypothetical population
effect size.  To know how to specify the hypothetical effect size according
to a distribution and an example of application see
\code{vignette("retrospective")}.
}

\references{
Altoè, G., Bertoldo, G., Zandonella Callegher, C., Toffalini, E.,
 Calcagnì, A., Finos, L., & Pastore, M. (2020). Enhancing Statistical
 Inference in Psychological Research via Prospective and Retrospective Design
 Analysis. Frontiers in Psychology, 10.
 \doi{10.3389/fpsyg.2019.02893}

 Bertoldo, G., Altoè, G., & Zandonella Callegher, C. (2020, June 15).
 Designing Studies and Evaluating Research Results: Type M and Type S Errors
 for Pearson Correlation Coefficient. Retrieved from
 \url{https://osf.io/preprints/psyarxiv/q9f86/}

 Gelman, A., & Carlin, J. (2014). Beyond Power Calculations: Assessing Type S
 (Sign) and Type M (Magnitude) Errors. Perspectives on Psychological Science,
 9(6), 641–651. \doi{10.1177/1745691614551642}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://claudiozandonella.github.io/PRDA/}
  \item \url{https://github.com/ClaudioZandonella/PRDA}
  \item Report bugs at \url{https://github.com/ClaudioZandonella/PRDA/issues}
}

}
\author{
\strong{Maintainer}: Claudio Zandonella Callegher \email{claudiozandonella@gmail.com} (\href{https://orcid.org/0000-0001-7721-6318}{ORCID})

Authors:
\itemize{
  \item Massimiliano Pastore \email{massimiliano.pastore@unipd.it} (\href{https://orcid.org/0000-0002-7922-6365}{ORCID})
  \item Angela Andreella \email{a.andreella8@gmail.com} (\href{https://orcid.org/0000-0002-1141-3041}{ORCID})
  \item Anna Vesely \email{anna.vesely92@gmail.com} (\href{https://orcid.org/0000-0001-6696-2390}{ORCID})
  \item Enrico Toffalini \email{enrico.toffalini@yahoo.it} (\href{https://orcid.org/0000-0002-1404-5133}{ORCID})
  \item Giulia Bertoldo \email{giuliabertoldo94@gmail.com} (\href{https://orcid.org/0000-0002-6960-3980}{ORCID})
  \item Gianmarco Altoè \email{gianmarco.altoe@unipd.it} (\href{https://orcid.org/0000-0003-1154-9528}{ORCID})
}

}
\keyword{internal}
