% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Monocot_MethPred.R
\name{Monocot_MethPred}
\alias{Monocot_MethPred}
\title{DNA Methylation Prediction in Monocot Plants}
\usage{
Monocot_MethPred(fasta_file_path, Reference = "Rice")
}
\arguments{
\item{fasta_file_path}{Sequence file (.fasta format)}

\item{Reference}{Rice as Reference Model for Monocot plants}
}
\value{
Methylation Status: Sequences with their probable DNA methylation state such as 5mC, 6mA or Non Methhylated.
}
\description{
Predicting sequences with DNA methylation sites like 5mC or 6mA based on Rice as reference model.
}
\examples{
\donttest{
library(OpEnCAST)
data<-system.file("exdata/test.fasta", package = "OpEnCAST")
pred<-Monocot_MethPred(fasta_file_path=data, Reference="Rice")
}

}
\references{
Lv, H., Dao, F. Y., Zhang, D., Guan, Z. X., Yang, H., Su, W., ... & Lin, H. (2020). iDNA-MS: an integrated computational tool for detecting DNA modification sites in multiple genomes. Iscience, 23(4).
}
