% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getFullPredictionPerformances}
\alias{getFullPredictionPerformances}
\title{Extract the model performances per evaluation}
\usage{
getFullPredictionPerformances(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  databaseTablePrefix = "",
  modelDesignId = NULL,
  developmentDatabaseId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{databaseTablePrefix}{A prefix to the database table, either '' or 'plp_'}

\item{modelDesignId}{The identifier for a model design  to restrict results to}

\item{developmentDatabaseId}{The identifier for the development database to restrict results to}
}
\value{
Returns a data.frame with the columns:
\itemize{  
 \item{timeStamp the date/time when the analysis occurred}
 \item{performanceId the unique identifier for the performance}
 \item{modelDesignId the unique identifier for the model design}
 \item{modelType the type of classifier}
 \item{covariateName a summary name for the candidate covariates}
 \item{developmentDatabaseId the unique identifier for the database used to develop the model}
 \item{validationDatabaseId the unique identifier for the database used to validate the model}
 \item{developmentTargetId the unique cohort id for the development target population}
 \item{developmentTargetName the name for the development target population}
 \item{validationTargetId the id for the validation target population}
 \item{validationTargetName the name for the validation target population if different from development}
 \item{developmentOutcomeId the unique cohort id for the development outcome}
 \item{developmentOutcomeName the name for the development outcome}
 \item{validationOutcomeId the id for the validation outcome}
 \item{validationOutcomeName the name for the validation outcome if different from development}
 \item{developmentDatabase the name for the database used to develop the model}
 \item{validationDatabase the name for the database used to validate the model if different from development}
 \item{validationTarId the validation time at risk id}
 \item{validationTimeAtRisk the time at risk used when evaluating the model if different from development}
 \item{developmentTarId the development time at risk id}
 \item{developmentTimeAtRisk the time at risk used when developing the model}
 \item{evaluation The type of evaluation: Test/Train/CV/Validation}
 \item{populationSize the test/validation population size used to develop the model}
 \item{outcomeCount the test/validation outcome count used to develop the model}
 \item{AUROC the AUROC value for the model}
 \item{95 lower AUROC: the lower bound of the 95 percent CI AUROC value for the model}
 \item{95 upper AUROC: the upper bound of the 95 percent CI AUROC value for the model}
 \item{AUPRC the discrimination AUPRC value for the model}
 \item{brier score: the brier value for the model}
 \item{brier score scaled: the scaled brier value for the model}
 \item{Average Precision: the average precision value for the model}
 \item{Eavg the calibration average error e-statistic value for the model}
 \item{E90 the calibration 90 percent upper bound e-statistic value for the model}
 \item{Emax the calibration max error e-statistic value for the model}
 \item{calibrationInLarge mean prediction: the  calibration in the large mean predicted risk value for the model}
 \item{calibrationInLarge observed risk: the calibration in the large mean observed risk value for the model}
 \item{calibrationInLarge intercept: the calibration in the large value intercept for the model}
 \item{weak calibration intercept: the weak calibration intercept for the model}
 \item{weak calibration gradient: the weak calibration gradient for the model}
 \item{Hosmer Lemeshow calibration intercept: the Hosmer Lemeshow calibration intercept for the model}
 \item{Hosmer Lemeshow calibration gradient: the Hosmer Lemeshow calibration gradient for the model}
 \item{... Additional metrics that are added to PLP}
}
}
\description{
This function extracts the model performances per evaluation
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) a modelDesignId and/or developmentDatabaseId to restrict models to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

perf <- getFullPredictionPerformances(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Prediction: 
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
