% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getDechallengeRechallenge}
\alias{getDechallengeRechallenge}
\title{Extract the dechallenge rechallenge results}
\usage{
getDechallengeRechallenge(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item{dechallengeStopInterval An integer specifying the how much time to add to the cohort_end when determining whether the event starts during cohort and ends after}
 \item{dechallengeEvaluationWindow A period of time evaluated for outcome recurrence after discontinuation of exposure, among patients with challenge outcomes}
 \item{numExposureEras Distinct number of exposure events (i.e. drug eras) in a given target cohort}
 \item{numPersonsExposed Distinct number of people exposed in target cohort. A person must have at least 1 day exposure to be included}
 \item{numCases Distinct number of persons in outcome cohort. A person must have at least 1 day of observation time to be included}
 \item{dechallengeAttempt Distinct count of people with observable time after discontinuation of the exposure era during which the challenge outcome occurred}
 \item{dechallengeFail Among people with challenge outcomes, the distinct number of people with outcomes during dechallengeEvaluationWindow}
 \item{dechallengeSuccess Among people with challenge outcomes, the distinct number of people without outcomes during the dechallengeEvaluationWindow}
 \item{rechallengeAttempt Number of people with a new exposure era after the occurrence of an outcome during a prior exposure era}
 \item{rechallengeFail Number of people with a new exposure era during which an outcome occurred, after the occurrence of an outcome during a prior exposure era}
 \item{rechallengeSuccess Number of people with a new exposure era during which an outcome did not occur, after the occurrence of an outcome during a prior exposure era}
 \item{pctDechallengeAttempt Percent of people with observable time after discontinuation of the exposure era during which the challenge outcome occurred}
 \item{pctDechallengeFail Among people with challenge outcomes, the percent of people without outcomes during the dechallengeEvaluationWindow}
 \item{pctDechallengeSuccess Among people with challenge outcomes, the percent of people with outcomes during dechallengeEvaluationWindow}
 \item{pctRechallengeAttempt Percent of people with a new exposure era after the occurrence of an outcome during a prior exposure era}
 \item{pctRechallengeFail Percent of people with a new exposure era during which an outcome did not occur, after the occurrence of an outcome during a prior exposure era}
 \item{pctRechallengeSuccess Percent of people with a new exposure era during which an outcome occurred, after the occurrence of an outcome during a prior exposure era}
 }
}
\description{
This function extracts all dechallenge rechallenge results across databases for specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

dcrc <- getDechallengeRechallenge(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
