% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proto.R
\name{proto}
\alias{proto}
\title{Extract the prototype from each variable group}
\usage{
proto(X, y, groups, type = c("max", "median"), mu = NULL)
}
\arguments{
\item{X}{Predictor matrix.}

\item{y}{Response matrix with one column.}

\item{groups}{An group index vector containing the
group number each variable belongs to. For example:
\code{c(1, 1, 1, 1, 1, 2, 2, 2, ...)}.
Variable groups can be generated by the Fisher optimal
partition algorithm implemented in \code{\link[=FOP]{FOP()}}.}

\item{type}{The rule for extracting the prototype.
Possible options are \code{"max"} and \code{"median"}.}

\item{mu}{The mean value of \code{y} for standardization.
Default is \code{NULL}, which uses the sample mean of \code{y}.}
}
\value{
The prototypes (variable index) extracted
from each group (cluster).
}
\description{
Extracts the prototype from each variable group.
}
