% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{te_cont}
\alias{te_cont}
\title{Continuous  Transfer Entropy}
\usage{
te_cont(X, Y, p = 1, q = 1, k = 3, normalize = FALSE)
}
\arguments{
\item{X}{Integer vector, first time series.}

\item{Y}{Integer vector, the second time series.}

\item{p}{Integer, the lag parameter to use for the first vector, (p = 1 by default).}

\item{q}{Integer the lag parameter to use for the first vector, (q = 1 by default).}

\item{k}{Integer argument, the number of neighbors.}

\item{normalize}{Logical argument  for the option of normalizing value of TE (transfer entropy) (FALSE by default).
This normalization is different from the discrete case, because, here the term H (X(t)| X(t-1), ..., X(t-p)) may be negative.
Consequently, we use another technique, we divide TE by H0 - H (X(t)| X(t-1), ..., X(t-p), Yt-1), ..., Y(t-q)), where H0 is the max entropy (of uniform distribution).}
}
\description{
Continuous  Transfer Entropy
}
\details{
Computes the continuous Transfer Entropy from the second time series to the first one using the Kraskov estimation
}
\examples{
library (timeSeries)
library (NlinTS)
#load data
data = LPP2005REC
te = te_cont (data[,1], data[,2], 1, 1, 3)
print (te)
}
\references{
{
  \insertRef{kraskov2004estimating}{NlinTS}
}
}
