% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.jointLives.R
\docType{class}
\name{mortalityTable.jointLives-class}
\alias{mortalityTable.jointLives-class}
\alias{mortalityTable.jointLives}
\title{Class mortalityTable.jointLives - Life table for multiple joint lives}
\description{
A cohort life table obtained by calculating joint death probabilities for
multiple lives, each possibly using a different mortality table.
}
\section{Slots}{

\describe{
\item{\code{table}}{The \code{mortalityTable} object for all lives (vector if different tables should be used for the different persons)}
}}

\examples{
mortalityTables.load("Germany_Census")
table.JL = mortalityTable.jointLives(
    name = "ADSt 24/26 auf verbundene Leben",
    table = mort.DE.census.1924.26.male
)
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(1, 5, -5, 16))
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(0))
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(1, 5, 16))

}
