% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients.R
\name{grad_loglik_beta}
\alias{grad_loglik_beta}
\title{Log-likelihood gradient with respect to beta}
\usage{
grad_loglik_beta(alpha, beta, delta, omega, x)
}
\arguments{
\item{alpha}{Numeric scalar. Stability parameter of the stable distribution
(0 < \eqn{\alpha \le 2}), controlling tail thickness.}

\item{beta}{Numeric scalar. Skewness parameter of the stable distribution
(\eqn{-1 \le \beta \le 1}).}

\item{delta}{Numeric scalar. Location parameter of the stable distribution.}

\item{omega}{Numeric scalar. Scale parameter of the stable distribution
(omega > 0).}

\item{x}{Numeric vector. Observations at which the integral is computed.}
}
\value{
Numeric scalar: estimated gradient (or \code{NA_real_} on invalid input).
}
\description{
Log-likelihood gradient with respect to beta
}
