% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdbin.R
\name{mdbin}
\alias{mdbin}
\title{Linear and Nonlinear Dose-Response Meta-Regression for Binary Outcomes}
\usage{
mdbin(
  measure = c("RR", "OR"),
  event.e,
  n.e,
  event.c,
  n.c,
  dose,
  data,
  linear = TRUE,
  nonlinear = TRUE,
  x_axis = "Dose",
  y_axis = "Measured Effect",
  knots = c(0.1, 0.5, 0.9)
)
}
\arguments{
\item{measure}{Character string specifying the effect size measure.
Options are \code{"RR"} for relative risk or \code{"OR"} for odds ratio.}

\item{event.e}{Numeric vector of numbers of events in the experimental group.}

\item{n.e}{Numeric vector of sample sizes in the experimental group.}

\item{event.c}{Numeric vector of numbers of events in the control group.}

\item{n.c}{Numeric vector of sample sizes in the control group.}

\item{dose}{Numeric vector of dose levels corresponding to each study.}

\item{data}{A data frame containing the meta-analysis data.}

\item{linear}{Logical; if \code{TRUE}, a linear dose-response model is fitted.}

\item{nonlinear}{Logical; if \code{TRUE}, a nonlinear dose-response model using
restricted cubic splines is fitted.}

\item{x_axis}{Character string specifying the x-axis label for plots.}

\item{y_axis}{Character string specifying the y-axis label for plots.}

\item{knots}{Numeric vector of quantiles used to place knots for the nonlinear
restricted cubic spline model.}
}
\value{
An S3 object of class `dose`, which is a list containing:
\item{linear_model}{The fitted linear dose-response meta-regression model.}
\item{linear_plot}{A plot of the linear dose-response relationship.}
\item{nonlinear_model}{The fitted nonlinear dose-response meta-regression model.}
\item{nonlinear_plot}{A plot of the nonlinear dose-response relationship.}
}
\description{
Performs linear and/or nonlinear dose-response meta-regression for binary
outcomes using study-level event data. The function supports relative risk (`RR`)
and odds ratio (`OR`) effect measures and models the association between dose
levels and treatment effects.
}
\details{
The function computes logarithmic effect sizes and corresponding sampling
variances from binary outcome data. Linear and/or nonlinear dose-response
meta-regression models are then fitted, with nonlinear relationships modeled
using restricted cubic splines. Dose-response plots are generated to visualize
the fitted associations.
}
\seealso{
\code{\link{mdcont}} for dose-response meta-regression with continuous outcomes.
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
