% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaletteCode.R
\name{scale_fill_met_d}
\alias{scale_fill_met_d}
\title{MetBrewer palettes for plotting with ggplot2}
\usage{
scale_fill_met_d(name, direction = 1, override.order = FALSE, ...)
}
\arguments{
\item{name}{Name of Palette. Choices are:
\code{Archambault}, \code{Austria}, \code{Benedictus}, \code{Cassatt1}, \code{Cassatt2}, \code{Cross}, \code{Degas},
\code{Demuth}, \code{Derain}, \code{Egypt}, \code{Gauguin}, \code{Greek}, \code{Hiroshige}, \code{Hokusai1},
\code{Hokusai2}, \code{Hokusai3}, \code{Homer1}, \code{Homer2}, \code{Ingres}, \code{Isfahan1}, \code{Isfahan2},
\code{Java}, \code{Johnson},\code{Juarez}, \code{Kandinsky}, \code{Klimt}, \code{Lakota}, \code{Manet},
\code{Monet}, \code{Moreau}, \code{Morgenstern}, \code{Nattier}, \code{Navajo}, \code{NewKingdom}, \code{Nizami},
\code{OKeeffe1}, \code{OKeeffe2}, \code{Paquin}, \code{Peru1}, \code{Peru2}, \code{Pillement}, \code{Pissaro},
\code{Redon}, \code{Renoir}, \code{Signac}, \code{Tam}, \code{Tara}, \code{Thomas}, \code{Tiepolo}, \code{Troy},
\code{Tsimshian}, \code{VanGogh1}, \code{VanGogh2}, \code{VanGogh3}, \code{Veronese}, and \code{Wissing}}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1, palette color order is reversed}

\item{override.order}{Colors are picked from palette to maximize readability and aesthetics. This means
that colors are not always selected in sequential order from the full palette. If override.order is set to TRUE,
colors are selected in sequential order from the full palette instead. Default is FALSE.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\description{
Function for using \code{MetBrewer} colors schemes in \code{ggplot2}. Use \code{\link{scale_color_met_d}} and \code{\link{scale_fill_met_d}}
for discrete scales and \code{\link{scale_color_met_c}} and \code{\link{scale_fill_met_c}} for continuous scales.
}
\examples{
library(ggplot2)
ggplot(data=iris, aes(x=Species, y=Sepal.Length, fill=Species)) +
geom_violin() +
scale_fill_met_d("Lakota")
}
