% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSpectra.R
\name{PlotSpectra}
\alias{PlotSpectra}
\title{Plot spectral data with optional peak markers}
\usage{
PlotSpectra(
  SpectralData,
  absx = "ALL",
  Peaks = NULL,
  Peaks2 = NULL,
  col_spec = 1,
  col_peak = 2,
  shape_peak = 3,
  col_peak2 = 2,
  shape_peak2 = 2,
  tol = 0
)
}
\arguments{
\item{SpectralData}{An object containing spectrum data with numeric slots
\verb{@mass} (m/z) and \verb{@intensity} (signal). Typically a MALDIquant
MassSpectrum-like S4 object.}

\item{absx}{Either the string "ALL" to plot the full m/z range, or a numeric
length-2 vector c(min, max) specifying the m/z window to display.}

\item{Peaks}{Optional MassPeaks object (e.g., from MALDIquant) providing
detected peak positions (\verb{@mass}) and intensities (\verb{@intensity}) to plot as points.}

\item{Peaks2}{Optional numeric or character vector of m/z values to highlight.
If character/factor, values are coerced to numeric (non-numeric chars removed).
Vertical dashed lines are drawn at these m/z. If \code{Peaks} is also supplied,
points are plotted for peaks whose m/z match \code{Peaks2} (within \code{tol}).}

\item{col_spec}{Colour for the spectrum line. Default: 1 (black).}

\item{col_peak}{Colour for points corresponding to all peaks in \code{Peaks}.
Default: 2 (red).}

\item{shape_peak}{Point shape for \code{Peaks} points. Default: 3.}

\item{col_peak2}{Colour for points corresponding to the subset of \code{Peaks}
that match \code{Peaks2}. Default: 2 (red).}

\item{shape_peak2}{Point shape for the \code{Peaks2}-matched points. Default: 2.}

\item{tol}{Numeric tolerance (in m/z units) used to match \code{Peaks@mass} to
\code{Peaks2}. Set to 0 for exact matching (may miss due to floating-point
precision). Default: 0.}
}
\value{
A ggplot object representing the spectrum and optional annotations.
}
\description{
Create a ggplot of a mass spectrum with optional points for detected peaks
and optional vertical lines (and points) highlighting user-specified m/z values.
}
\examples{
\donttest{
if (requireNamespace("MALDIquant", quietly = TRUE)) {
# Load mass spectra
 data("CitrobacterRKIspectra", package = "MSclassifR")
# Plot raw mass spectrum
 PlotSpectra(SpectralData = CitrobacterRKIspectra[[1]])
# standard pre-processing of mass spectra
 spectra <- SignalProcessing(CitrobacterRKIspectra)
# Plot pre-processed mass spectrum
 PlotSpectra(SpectralData=spectra[[1]])
# detection of peaks in pre-processed mass spectra
 peaks <- PeakDetection(x = spectra, averageMassSpec=FALSE)
# Plot peaks on pre-processed mass spectrum
 PlotSpectra(SpectralData=spectra[[1]],Peaks=peaks[[1]],col_spec="blue",col_peak="black")
}
}
}
