% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{pairwise}
\alias{pairwise}
\title{Pairwise comparisons of random parameters.}
\usage{
pairwise(
  mires,
  param = c("lambda", "resid", "nu"),
  prob = 0.95,
  less_than = 0.1,
  groups = NULL,
  ...
)
}
\arguments{
\item{mires}{mires object.}

\item{param}{Character. One of \code{lambda} (loadings), \code{resid} (residual standard deviation on the log scale), or \code{nu} (intercepts).}

\item{prob}{Numeric (0-1). Probability mass contained within the highest density interval.}

\item{less_than}{Numeric (Default: .1; positive). Value at which to assess Pr(|difference| < less_than|D).}

\item{groups}{Character vector (Optional). If specified, will only compute pairwise differences of the specified groups.}

\item{...}{Not used.}
}
\value{
Data frame.
}
\description{
Compute pairwise differences in group-specific measurement parameters.
}
\details{
For a specified set of parameters, this computes all pairwise differences in the random effects across the posterior. Specifically, this computes the posterior differences of groups' parameters, for all parameters. This is useful for comparing groups' estimates under non-invariance.
}
\author{
Stephen Martin
}
