\name{plot.cca}
\alias{plot.cca}
\title{
  Plot for corresponding age range for tooth dentin serial sections
}
\description{
  \code{plot.cca} is a plotting utile for quick visualization of the modeled age range of tooth dentin serial sections under an object of class \code{"cca"}. The modeled age ranges are plotted for each section.
}
\usage{
  \method{plot}{cca}(x, age = NULL, delta = NULL, error = 0.1, \dots)
}
\arguments{
  \item{x}{An object of class \code{"cca"} generated by \code{\link{cca}}.
}
  \item{age}{Numeric vector of originally assigned ages for each section. If omitted, midpoint ages calculated with equal temporal division according to the relative height of sections are used.}
  \item{delta}{Numeric vector of stable isotope ratios for each section. If omitted, corresponding age ranges are plotted without information on stable isotope ratios.}
  \item{error}{Analytical error of stable isotope ratios. Default is 0.1.}
  \item{\dots}{Additional arguments passed to \code{\link{plot}}.}
}
\details{
  If the argument \code{delta} is omitted, the corresponding age ranges for each serial section are plotted with its positions in the standardized y-axis. If the argument \code{delta} is specified, the originally-assigned ages and the modeled age ranges for each section are plotted with its stable isotope ratios. 
}
\references{
  Tsutaya T 2020. Blurred time resolution of tooth dentin serial sections. American Journal of Physical Anthropology 173:748--759. DOI: 10.1002/ajpa.24113.
}
\author{
  Takumi Tsutaya developed this model.
}
\seealso{
  \code{\link{MDSS}}, \code{\link{mds}}, \code{\link{cca}}
}
\examples{
## See ?cca for examples.
}
\keyword{math}
