% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Opt1.R
\name{Opt1}
\alias{Opt1}
\title{The Opt1 chooses the optimal index subset based on minimized interval length.}
\usage{
Opt1(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}
}
\value{
MUopt1,Bopt1,MAEMUopt1,MSEMUopt1,opt1,Yopt1
}
\description{
The Opt1 chooses the optimal index subset based on minimized interval length.
}
\examples{
set.seed(12)
X=matrix(data=sample(1:3,1200*5, replace = TRUE) ,nrow=1200,ncol=5)  
b=sample(1:3,5, replace = TRUE)         
e= rnorm(1200, 0, 1)    
Y=X\%*\%b+e
alpha=0.05	
K=10
nk=1200/K 
Opt1(X,Y,alpha,K,nk)
}
