% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arriaga.R
\name{sen_arriaga}
\alias{sen_arriaga}
\title{the sensitivity implied by a classic Arriaga decomposition}
\usage{
sen_arriaga(
  mx1,
  mx2,
  age = 0:(length(mx1) - 1),
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
\code{s} numeric vector with one element per age group, and which gives the sensitivity values for each age.
}
\description{
The sensitivity of life expectancy to a perturbation in mortality rates can be derived by dividing the Arriaga decomposition result \eqn{\Delta} by the difference \code{mx2-mx1}.
\deqn{s_{x} = \frac{\Delta}{_{n}M^{2}_x - _{n}M^{1}_x}}
}
\examples{
a <- .001
b <- .07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
cc <- arriaga(mx1, mx2, age = x)
# examples can come from above too
s <- sen_arriaga(mx1, mx2, age = x)
\donttest{
plot(x, s)
}
cc_check <- s * (mx2 - mx1)
\donttest{
plot(x,cc)
lines(x,cc_check)
}
}
\references{
\insertRef{arriaga1984measuring}{LEdecomp}
\insertRef{preston2000demography}{LEdecomp}
}
\seealso{
\code{\link{arriaga}}
}
