% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBSPRfit.r
\name{LBSPRfit}
\alias{LBSPRfit}
\title{Fit LBSPR model to length data}
\usage{
LBSPRfit(
  LB_pars = NULL,
  LB_lengths = NULL,
  yrs = NA,
  Control = list(),
  pen = TRUE,
  verbose = TRUE,
  useCPP = TRUE,
  ...
)
}
\arguments{
\item{LB_pars}{an object of class \code{'LB_pars'} that contains the life history information}

\item{LB_lengths}{an object of class \code{'LB_lengths'} that contains the length data}

\item{yrs}{index of years to include. If NA the model is run on all years}

\item{Control}{a list of control options for the LBSPR model.}

\item{pen}{apply a penalty if estimate of selectivity is very high?}

\item{verbose}{display messages?}

\item{useCPP}{use cpp optimization code?}

\item{...}{additional parameters to pass to \code{FilterSmooth}}
}
\value{
a object of class \code{'LB_obj'}
}
\description{
A function that fits the LBSPR model to length data
}
\details{
The Control options are:
\describe{
 \item{\code{modtype}}{Model Type: either Growth-Type-Group Model (default: "GTG") or Age-Structured ("absel")}
 \item{\code{maxsd}}{Maximum number of standard deviations for length-at-age distribution (default is 2)}
 \item{\code{ngtg}}{Number of groups for the GTG model. Default is 13}
 \item{\code{P}}{Proportion of survival of initial cohort for maximum age for Age-Structured model. Default is 0.01}
 \item{\code{Nage}}{Number of pseudo-age classes in the Age Structured model. Default is 101}
 \item{\code{maxFM}}{Maximum value for F/M. Estimated values higher than this are trunctated to \code{maxFM}. Default is 4}
}
}
\examples{
\dontrun{
MyFit <- LBSPRfit(LBparameters, LBlengths)
MyFit@Ests
}

}
\author{
A. Hordyk
}
