% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_dataset}
\alias{simulate_dataset}
\title{Simulate a dataset given model parameters.}
\usage{
simulate_dataset(
  n,
  later_mu,
  later_sd,
  early_sd = NULL,
  seed = NA,
  allow_negative_times = FALSE
)
}
\arguments{
\item{n}{Number of samples (trials)}

\item{later_mu}{Mean of the later component.}

\item{later_sd}{Standard deviation of the later component.}

\item{early_sd}{Standard deviation of the early component,
or \code{NULL} if there is no early component (the default).}

\item{seed}{Seed for the random number generator}

\item{allow_negative_times}{If \code{FALSE} (the default), any random samples
that have negative response times are iteratively replaced such that all
returned samples are positive. If \code{TRUE}, no such replacement is performed.}
}
\value{
Vector of response times (in seconds)
}
\description{
Generates samples from a set of provided LATER model parameters,
with the option to iteratively replace invalid samples (reaction
times <= 0).
}
\examples{
simulate_dataset(n = 100, later_mu = 5, later_sd = 1)
simulate_dataset(n = 100, later_mu = 5, later_sd = 1, early_sd = 5)
}
