% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KneeArrow.R
\name{derivative}
\alias{derivative}
\title{Derivative of a function with respect to x}
\usage{
derivative(x, y, m = 0, n = 50)
}
\arguments{
\item{x}{x coordinates of points in function's domain}

\item{y}{y coordinates of points in function's range}

\item{m}{the order of the derivative (0 for y, 1 for y', 2 for y'')}

\item{n}{number of points in the domain for interpolation}
}
\value{
a function representing the mth derivative of y(x) with respect to x
}
\description{
Derivative of a function with respect to x
}
\examples{
x <- seq(0,5,0.1)
y <- x^2 - 2*x + 3 # So dy/dx = 2x - 2
fp <- derivative(x, y, 1)
fp(2) # 2
fp(5) # 8
}
