% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imneuron.R
\name{Imneuron}
\alias{Imneuron}
\title{Fitting of AI based Neural Network Model}
\usage{
Imneuron(data, target_variable, hidden_neurons_range, cv_type = "5-fold")
}
\arguments{
\item{data}{dataset containing the information about all the variables which are continuous in nature}

\item{target_variable}{response variable}

\item{hidden_neurons_range}{This is a range of values specifying the number of hidden neurons to explore in the neural network's two layers (Layer 1 and Layer 2)}

\item{cv_type}{This argument is used to apply cross validation like "5_fold" for 5 folded cross validation and "10-fold" for 10 folded cross validation}
}
\value{
Average values of R2, RMSE, MAE, and PER across the cross-validation folds.    The trained neural network models for each fold.    A data frame containing the evaluation metrics for each fold
}
\description{
Fitting of AI based Neural Network Model
}
\examples{
# 5-fold cross-validation
\donttest{
data(fruit)
results_5fold <- Imneuron(fruit, "Fruit.Yield", hidden_neurons_range = c(2,2), cv_type = "5-fold")
results_10fold <- Imneuron(fruit, "Fruit.Yield", hidden_neurons_range = c(2,2), cv_type = "10-fold")
}
}
\references{
Jeelani, M.I., Tabassum, A., Rather, K and Gul, M. (2023). Neural Network Modeling of Height Diameter Relationships for Himalayan Pine through Back Propagation Approach. Journal of The Indian Society of Agricultural Statistics. 76(3): 169.
Tabassum, A., Jeelani, M.I., Sharma,M., Rather, K R ., Rashid, I and Gul, M. (2022). Predictive Modelling of Height and Diameter Relationships of Himalayan Chir Pine. Agricultural Science Digest - A Research Journal. <doi:10.18805/ag.D-5555>
}
