% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterplot.R
\name{rasterplot}
\alias{rasterplot}
\title{Fast 2D plot}
\usage{
rasterplot(
  x,
  y = NULL,
  pch = ".",
  size = 7,
  alpha = 255,
  col = "black",
  rgba = NULL,
  force = FALSE,
  draw = TRUE,
  new = is.null(bg_),
  interpolate = FALSE,
  width = 512,
  height = 512,
  pntsonedge = FALSE,
  blur_size = 9,
  blur_sd = 3,
  bg_ = NULL,
  bg_map = TRUE,
  ...
)
}
\arguments{
\item{x, y}{the x and y coordinates for the plot. If 'y' is NULL, it will be same as 'x'.
x and y should have same length.}

\item{pch}{a vector of plotting symbols. Default is "." (resulting in a 1-pixel dot). Allowed are 0 to 20 and ".". It will be repeated along 'x'. 
With the exception of ".", NA resulting its coercion to integer(s) from the conversion will be omitted
(i.e. points won't be displayed, but their x-y coordinates will account for xlim, ylim range computation when not provided through ...).
Everything else (coercible to integer) will result in a dot (a 1-pixel pixel).}

\item{size}{an integer vector giving the size(s) of the 'pch'. Default is 7. It will be repeated along 'x'.}

\item{alpha}{a [0,255] integer. Default is 255.}

\item{col}{a vector of desired colors of the symbols that will be passed by grDevices::col2rgb('x', alpha = TRUE). Default is "black".
If number of colors equals number of points every point will be assigned this color.
Otherwise, if color is of length 1 for a single combination of size / pch, all points with this combination will be assigned this color.
Finally, if there is only one combination of size / pch and color not equals 1 nor the total number of points,
then, colors will be used as a gradient for density (in such case 'blur_size' and 'blur_sd' will be taken in consideration)
This only applies when 'force' is FALSE.}

\item{rgba}{a 4 rows color matrix, with rows being Red, Green, Blue and Alpha and number of columns identical to number of points.\cr
/!\ When provided this argument will take precedence over 'col' and 'alpha'.}

\item{force}{whether to force scatter instead of density when multiple 'col' are provided}

\item{draw}{whether to draw to plot (when TRUE), or to image only (when FALSE). Default is TRUE.}

\item{new}{whether a new plot should be created, only applies when 'draw' is TRUE. Default is is.null(bg_).
If FALSE, the current plot will be used to draw points.}

\item{interpolate}{whether to use linear interpolation, only applies when 'draw' is TRUE. Default is FALSE.}

\item{width}{the desired width of the raster Default is 512. It only applies when draw is FALSE.}

\item{height}{the desired height of the raster Default is 512. It only applies when draw is FALSE.}

\item{pntsonedge}{whether points outside of plotting region should be bounded on the edge. Default is FALSE to clip points.}

\item{blur_size}{(for density) an integer controlling the size of the blurring gaussian kernel. Default is 9.}

\item{blur_sd}{(for density) a double controlling the sd of the blurring gaussian kernel. Default is 3.}

\item{bg_}{an `rasterplot` object as returned by rasterplot() that will be used to add points to. Default is NULL.
If provided it will have to be compatible with current drawing size or 'width' and 'height' when 'draw' is FALSE.}

\item{bg_map}{whether to use 'bg_' when provided to compute points coordinates. Default is TRUE.
This allows to get same "user" to "pixel" coordinates conversion as the one used to create 'bg_'.}

\item{...}{other arguments to pass to graphics::plot().
For example, providing xlim and/or ylim will controls if point will be shown or not}
}
\value{
an [0, 255] integer array of (height, width, 4) of class `rasterplot`
}
\description{
Creates fast 2D plots with Rcpp
}
\details{
some examples:\cr
set.seed(2)\cr
n_points = 1e7; n_clusters = 5\cr
x = c(t(sapply(1:5, FUN = function(i) rnorm(n_points / n_clusters, mean = sample(-2:2, size = 1), sd = 1/sample(1:10, 1)))))\cr
y = c(t(sapply(1:5, FUN = function(i) rnorm(n_points / n_clusters, mean = sample(-2:2, size = 1), sd = 1/sample(1:10, 1)))))\cr
# plot points\cr
rasterplot(x = x, y = y, col = "black")\cr
# generate img\cr
rasterplot(x = x, y = y, col = "black", draw = FALSE)\cr
# plot multiple shapes\cr
rasterplot(x = x, y = y, pch = c(3,5,9,10,2))\cr
# plot multiple shapes + colors\cr
bg_ = rasterplot(x = x, y = y, pch = c(3,5,9,10,2), col = c("plum", "green", "indianred", "blue", "black"))\cr
# addition of new points to an already drawn background, it a kind of points(...)\cr
rasterplot(x = x[1:1e5], y = y[1:1e5], col = "black", bg_ = bg_, bg_map = TRUE)\cr
# plot 1 shape  + multiple colors\cr
rasterplot(x = x, y = y, pch = ".", col = c("plum", "green", "indianred", "blue", "black"), force = TRUE)\cr
# density\cr
rasterplot(x = x, y = y, pch = 20, size = 7, draw = TRUE, col = colorRampPalette(c("blue", "green", "red"))(100))\cr
# density with limits\cr
rasterplot(x = x, y = y, draw = TRUE, xlim = c(0, 1.5), pntsonedge = FALSE, col = colorRampPalette(c("blue", "green", "red"))(100))\cr
# density with limits + computation on drawn points only\cr
rasterplot(x = x, y = y, draw = TRUE, xlim = c(0, 1.5), pntsonedge = TRUE, col = colorRampPalette(c("blue", "green", "red"))(100))\cr
# using rgba\cr
col = c("plum", "green", "indianred", "blue", "black")\cr
rgba = col2rgb(col, alpha = TRUE)\cr
rgba = t(apply(rgba, 1, FUN = function(x) rep(x, length.out = n_points)))\cr
rasterplot(x = x, y = y, pch = ".", rgba = rgba, draw = TRUE)
}
\keyword{internal}
