% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{getSTATSREPORT}
\alias{getSTATSREPORT}
\title{Statistics Report Template Extraction}
\usage{
getSTATSREPORT(fileName)
}
\arguments{
\item{fileName}{path to file.}
}
\value{
a 6-columns character matrix describing report instructions:\cr
- \code{'name'}, for the desired name of exported \code{'statistics'},\cr
- \code{'type'}, for the type of stats to return (either \code{"value"} or \code{"ratio"}),\cr
- \code{'population1'}, determines the population on which \code{'statistics'} will be performed,\cr
- \code{'population2'}, determines the reference population (when \code{'type'} is \code{"ratio"}, see \strong{Details}),\cr
- \code{'feature'}, determines the feature's name on which \code{'statistics'} will be computed,\cr
- \code{'statistics'}, controls the mathematical function that will be applied (see \strong{Details}).
}
\description{
Retrieves statistics report template from .ast / .daf files.
}
\details{
Allowed \code{'statistics'} names are: \code{"Count"},\code{"Mean"},\code{"\%Total"},\code{"\%Gated"},\code{"\%"},\code{"Objects/mL"},\code{"RD - Mean"},
\code{"Median"},\code{"CV"},\code{"stddev"},\code{"NaN"},\code{"MAD"},\code{"min"},\code{"RD - Median"},\code{"Variance"},\code{"max"},\code{"geomean"},\code{"Mode"}.\cr
For \code{"\%Total"},\code{"\%Gated"},\code{"\%"},\code{"RD - Mean"},\code{"RD - Median"}, \code{'type'} has to be \code{"ratio"} and both \code{'population1'}
and \code{'population2'} should be provided. Otherwise, \code{'type'} is \code{"value"} and only \code{'population1'} is mandatory.\cr
\strong{/!\\} Note that \code{"Mode"} and \code{"Objects/mL"} can't be determined and will result in \code{NA}.
}
\keyword{internal}
