% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToXIF.R
\name{ExportToXIF}
\alias{ExportToXIF}
\title{RIF/CIF File Writer}
\usage{
ExportToXIF(
  fileName,
  write_to,
  objects,
  offsets,
  fast = TRUE,
  extract_features = FALSE,
  endianness = .Platform$endian,
  verbose = FALSE,
  verbosity = 1,
  overwrite = FALSE,
  display_progress = TRUE,
  add_tracking = TRUE,
  ...
)
}
\arguments{
\item{fileName}{path(s) of file(s) to subset or merge.
If multiple files are provided they will be merged. Otherwise, if only one file is input it will be subsetted.
All files have to be either '.rif' or '.cif' files.
All files should have same channels.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of first element of 'fileName'\cr
-\%p: with first parent directory of first element of 'fileName'\cr
-\%e: with extension of first element of 'fileName' (without leading .)\cr
-\%s: with shortname from of first element of 'fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. It has to be the same as 'fileName', i.e. .cif or .rif.}

\item{objects}{integer vector, IDEAS objects ids numbers to use. If missing, the default, all objects will be used. Only apply for subsetting.}

\item{offsets}{object of class `IFC_offset`. If missing, the default, offsets will be extracted from 'fileName'.\cr
This param is not mandatory but it may allow to save time for repeated XIF export on same file. Only apply for subsetting.}

\item{fast}{whether to fast extract 'objects' or not. Default is TRUE.
Meaning that 'objects' will be extracted expecting that 'objects' are stored in ascending order.\cr
Note that a warning will be sent if an 'object' is found at an unexpected order.
In such a case you may need to rerun function with 'fast' = FALSE.
If set to FALSE, all object_ids will be scanned from 'fileName' to ensure extraction of desired 'objects'.\cr
IMPORTANT: whatever this argument is, features are extracted assuming an ascending order of storage in file.\cr
Only apply for subsetting.}

\item{extract_features}{whether to try to extract features. Default is FALSE.
IMPORTANT: it is not clear if how features are stored and which objects they rely to when input file is already a merge or a subset.
For this reason it should be carefully checked.
Note that features extraction is not implemented for merging.}

\item{endianness}{the endian-ness ("big" or "little") of the target system for the file. Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{verbosity}{quantity of information displayed when verbose is TRUE; 1: normal, 2: rich. Default is 1.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.\cr
Note that if TRUE, it will overwrite exported file if path(s) of file(s) in 'fileName' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file, i.e. generated by IDEAS(R) or INSPIRE(R), will never be overwritten.
Otherwise, you will get an error saying that overwriting original file is not allowed.\cr}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{add_tracking}{whether to register files' paths and objects' ids in the exported file. Default is TRUE.}

\item{...}{other arguments to be passed.}
}
\value{
It invisibly returns full path of exported file.
}
\description{
Subsets or merges RIF or CIF files.
}
\details{
when 'extract_features' is set TRUE, only features stored in binary format will be extracted if found.\cr
If the input 'fileName' is a merged of several files then features will be extracted from these files.\cr
If these files can't be found, Warning(s) will be thrown and input 'fileName' will be extracted without features values.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  tmp <- tempdir(check = TRUE)
  ## use a cif file, but you can also subset rif
  file_cif <- system.file("extdata", "example.cif", package = "IFCdata")
  ## subset objects 0,1 and 4 from file
  exported <- ExportToXIF(fileName = file_cif, write_to = paste0(tmp, "\\\\test.cif"),
                          overwrite = TRUE, objects = c(0,1,4))
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
