% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selection}
\alias{selection}
\title{Selecting a subset of \code{q} variables}
\usage{
selection(x, y, q, prevar = NULL, criterion = "deviance", method = "lm",
  family = "gaussian", seconds = FALSE, nmodels = 1, nfolds = 5,
  cluster = TRUE, ncores = NULL)
}
\arguments{
\item{x}{A data frame containing all the covariates.}

\item{y}{A vector with the response values.}

\item{q}{An integer specifying the size of the subset of variables to be
selected.}

\item{prevar}{A vector containing the number of the best subset of
\code{q-1} variables. \code{NULL}, by default.}

\item{criterion}{The information criterion to be used.
Default is the deviance. Other functions provided
are the coefficient of determination (\code{"R2"}), the residual
variance (\code{"variance"}), the Akaike information criterion (\code{"aic"}),
AIC with a correction for finite sample sizes (\code{"aicc"})
and the Bayesian information criterion (\code{"bic"}). The deviance,
coefficient of determination and variance are calculated by cross-validation.}

\item{method}{A character string specifying which regression method is used,
i.e., linear models (\code{"lm"}), generalized additive models
(\code{"glm"}) or generalized additive models (\code{"gam"}).}

\item{family}{A description of the error distribution and link function to be
used in the model: (\code{"gaussian"}), (\code{"binomial"}) or
(\code{"poisson"}).}

\item{seconds}{A logical value. By default, \code{FALSE}.  If \code{TRUE}
then, rather than returning the single best model only, the function returns
a few of the best models (equivalent).}

\item{nmodels}{Number of secondary models to be returned.}

\item{nfolds}{Number of folds for the cross-validation procedure, for
\code{deviance}, \code{R2} or \code{variance} criterion.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
procedure is  parallelized. Note that there are cases without enough
repetitions (e.g., a low number of initial variables) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores to be used
is equal to the number of cores of the machine - 1.}
}
\value{
\item{Best model}{The best model. If \code{seconds=TRUE}, it returns
 also the best alternative models.}
 \item{Variable name}{Names of the variable.}
 \item{Variable number}{Number of the variables.}
 \item{Information criterion}{Information criterion used and its value.}
 \item{Prediction}{The prediction of the best model.}
}
\description{
Main function for selecting the best subset of \eqn{q} variables.
 Note that the selection procedure can be used with lm, glm or gam functions.
}
\examples{
library(FWDselect)
data(diabetes)
x = diabetes[ ,2:11]
y = diabetes[ ,1]
obj1 = selection(x, y, q = 1, method = "lm", criterion = "variance", cluster = FALSE)
obj1

# second models
obj11 = selection(x, y, q = 1, method = "lm", criterion = "variance",
seconds = TRUE, nmodels = 2, cluster = FALSE)
obj11

# prevar argument
obj2 = selection(x, y, q = 2, method = "lm", criterion = "variance", cluster = FALSE)
obj2
obj3 = selection(x, y, q = 3, prevar = obj2$Variable_numbers,
method = "lm", criterion = "variance", cluster = FALSE)


}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}

