% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_plot_wrapper.R
\name{oc_plot}
\alias{oc_plot}
\title{Generate Operating Characteristics Plots with S3 Support}
\usage{
oc_plot(...)
}
\arguments{
\item{...}{Either simulation result objects (from \code{run_simulation()}) or
legacy arguments (\code{`3+3`}, \code{BOIN}, \code{mTPI2}, \code{i3+3}, \code{G3}).}
}
\value{
A list of plots showing operating characteristics for the specified design(s).
}
\description{
Enhanced wrapper to generate OC plots that supports both legacy and S3 interfaces.
}
\examples{
# New S3 interface
boin <- design_boin(pT = 0.25, EI = c(0.15, 0.35), ncohort = 10)
i3 <- design_i3plus3(pT = 0.25, EI = c(0.2, 0.3), ncohort = 10)

p.true <- c(0.05, 0.10, 0.20, 0.30, 0.45)
mtd.true <- c(0, 0, 1, 0, 0)  # Dose 3 is the true MTD

\donttest{
# Run simulations
sim_boin <- run_simulation(boin, p.true = p.true, mtd.true = mtd.true)
sim_i3 <- run_simulation(i3, p.true = p.true, mtd.true = mtd.true)

# Generate OC plots
oc_plot(sim_boin, sim_i3)
}

}
