% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_ts_main.R
\name{ma_pmm2}
\alias{ma_pmm2}
\title{Fit an MA model using PMM2 (wrapper)}
\usage{
ma_pmm2(
  x,
  order = 1,
  method = "pmm2",
  max_iter = 50,
  tol = 1e-06,
  include.mean = TRUE,
  initial = NULL,
  na.action = na.fail,
  regularize = TRUE,
  reg_lambda = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{x}{Numeric vector of time series data}

\item{order}{Model order specification:
- For AR models: a single integer (AR order)
- For MA models: a single integer (MA order)
- For ARMA models: vector c(p, q) (AR and MA orders)
- For ARIMA models: vector c(p, d, q) (AR, differencing, and MA orders)}

\item{method}{String: estimation method, one of "pmm2" (default), "css", "ml", "yw", "ols"}

\item{max_iter}{Integer: maximum number of iterations for the algorithm}

\item{tol}{Numeric: tolerance for convergence}

\item{include.mean}{Logical: whether to include a mean (intercept) term}

\item{initial}{List or vector of initial parameter estimates (optional)}

\item{na.action}{Function for handling missing values, default is na.fail}

\item{regularize}{Logical, add small values to diagonal for numerical stability}

\item{reg_lambda}{Regularization parameter (if regularize=TRUE)}

\item{verbose}{Logical: whether to print progress information}
}
\value{
An S4 object of class \code{MAPMM2} containing moving-average
coefficients, residual innovations, central moments, model order,
intercept, original series, and convergence diagnostics.
}
\description{
Fit an MA model using PMM2 (wrapper)
}
