% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_phase_1d}
\alias{plot_phase_1d}
\title{1D Phase Diagram}
\usage{
plot_phase_1d(
  data,
  z_var,
  dz_var = NULL,
  show_zero_line = TRUE,
  show_fit = TRUE,
  fit_method = "loess"
)
}
\arguments{
\item{data}{Data frame.}

\item{z_var}{Name of state variable Z.}

\item{dz_var}{Name of derivative dZ (auto-constructed if starts with "d_").}

\item{show_zero_line}{Add horizontal line at dZ = 0?}

\item{show_fit}{Add nonparametric fit?}

\item{fit_method}{Method for fit: "loess", "gam", or "spline".}
}
\value{
A ggplot object.
}
\description{
Creates a phase diagram plotting dZ vs Z, useful for visualizing autonomous
dynamics and identifying fixed points.
}
\details{
In the phase diagram:
\itemize{
\item Points where the curve crosses dZ = 0 are fixed points
\item Negative slope at crossing indicates stability
\item Positive slope indicates instability
}
}
