% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetapopulationClass.R
\docType{class}
\name{Metapopulation-class}
\alias{Metapopulation-class}
\title{Metapopulation}
\description{
The class \code{Metapopulation} is used to centralise the information
relating to the populations that we want to simulate, as well as to define
the migration conditions between them if there are several. This class
is thus defined by a list of objects \code{Population} and a migration
matrix.
}
\section{Slots}{

\describe{
\item{\code{populations}}{list of objects \code{Population}}

\item{\code{nbPop}}{number of populations}

\item{\code{names}}{names of the populations}

\item{\code{migMat}}{migration matrix between population (if there is more than one)}

\item{\code{sizes}}{sizes of the populations}

\item{\code{dioecies}}{sexual systems of the populations (they must all be the same)}

\item{\code{selfRates}}{selfing rates of the populations}

\item{\code{demographies}}{demography parameter of the populations}

\item{\code{growthRates}}{growth rates of the populations}

\item{\code{initPopSizes}}{initial population sizes of the populations}

\item{\code{initGenoFreqs}}{initial genotypic frequencies of the populations}

\item{\code{genome}}{a \code{Genome} object}

\item{\code{genomeIDs}}{ID of the \code{Genome} object}

\item{\code{mutMat}}{a \code{MutationMatrix} object}

\item{\code{selection}}{a \code{Selection} object}

\item{\code{recMat}}{recombination matrix}

\item{\code{meiosisMat}}{a meiosis matrix}

\item{\code{haploCrossMat}}{an haplotype crossing matrix}

\item{\code{haploCrossMatNamed}}{an haplotype crossing matrix with names of
genotypes instead of their indices}

\item{\code{gametogenesisMat}}{a gametogenesis matrix}

\item{\code{alleleFreqMat}}{a matrix for calculating allelic frequencies}

\item{\code{rawOutputSimul}}{raw output of the simulation function, its refinement
is done directly afterwards in the \code{simulate} method}

\item{\code{stopCondition}}{list of stop conditions for the simulation (if required)}

\item{\code{IDstopCondition}}{names of stop conditions. They are given an arbitrary
name if none is given by the user.}

\item{\code{results}}{data.frame.}

\item{\code{records}}{list.}

\item{\code{customOutput}}{list.}
}}

\author{
Ehouarn Le Faou
}
