% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveOLS.R
\name{solveOLS}
\alias{solveOLS}
\title{solveOLS}
\usage{
solveOLS(S, B)
}
\arguments{
\item{S}{List output from trimData$sig (S)}

\item{B}{List output from trimData$bulk (B)}
}
\value{
Cell-type proportion
}
\description{
This function solves or the unknown parameters
using ordinary least squares (OLS). It is constrained such
that cell type numbers are greater than 0.
}
\examples{
\donttest{
#Sig
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/Sig.RData"
#dest <- "data/Sig.RData"
#download.file(url, dest)
#load("data/Sig.RData")
load(system.file("extdata", "Sig.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

trimmed <- trimData(Sig, dataBulk)
S <- trimmed$sig
B <- trimmed$bulk
solveOLS(S, B)
}
}
