% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEGRE.R
\name{DEGRE}
\alias{DEGRE}
\title{Infer the Differentially Expressed Genes}
\usage{
DEGRE(count_matrix, p_value_adjustment = "BH", formula, design_matrix)
}
\arguments{
\item{count_matrix}{a data.frame object. It receives the raw matrix as input.}

\item{p_value_adjustment}{a data.frame object. It receives the experimental design matrix. The sample names must be identified in the first column. This matrix can also have more columns with information for the fixed and the random effects for the samples.}

\item{formula}{it receives fixed and random effects descriptions.}

\item{design_matrix}{All the P-values computed must be corrected and the DEGRE package offers two possibilities: "BH" (Benjamini-Hochberg) correction (default) and "BON" (Bonferroni) correction.}
}
\value{
dataframe object
}
\description{
The DEGRE function acts inferring the differentially expressed genes fitting them using generalized linear mixed models and then applies the Wald test to the regression coefficients. It offers Benjamini-Hochberg or Bonferroni P-values techniques to adjust the P-values.
}
\examples{
\donttest{
# Reading the count matrix and the design matrix for an example:
dir <- system.file("extdata", package = "DEGRE")
tab <- read.csv(file.path(dir,"count_matrix_for_example.csv"))
des <- read.csv(file.path(dir,"design_matrix_for_example.csv"))
# Running DEGRE function:
results <- DEGRE(count_matrix = tab,
                 p_value_adjustment = "BH",
                 design_matrix = des,
                 formula = "condition + (1|sex)")
}
}
