% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{ssp}
\alias{ssp}
\title{Sunshine duration percentage}
\usage{
ssp(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{insolation, hours of sun}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
percentage
}
\description{
Sunshine duration fraction with respect to day length (%)
}
\section{Formula}{
 \deqn{SSP = \frac{SS} {SSmax} * 100} SS: sum of sunshine duration (h); SSmax: maximun daylight (h)
}

\examples{
data(data_all)
ssp(data = data_all$insolation)
}
\references{
European Climate Assessment & Dataset. Indices dictionary. \url{https://www.ecad.eu//indicesextremes/indicesdictionary.php}
}
