% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationStudyFunctions.R
\name{gg.rank.plot}
\alias{gg.rank.plot}
\title{Function for plotting selected joint ranks}
\usage{
gg.rank.plot(rank.dat, cols, show.legend = FALSE, text.size, num.sims)
}
\arguments{
\item{rank.dat}{data frame expected to be built with the functions dplyr::count and tidyr::complete, which should include the following variables
Rank - numeric values of the rank selected by each method in each replicate simulation
n - the number of times this value was selected as the rank
Type - the subspace for which the norm is given (i.e., joint/individual score/loading for dataset X1 or X2 (except for joint scores))
Method - the method by which the subspace was estimated, e.g. CJIVE, AJIVE, R.JIVE
JVE_1 and JVE_2 - labels describing the proportion of joint variation explained in each dataset (and typically the number of variables in dataset X2)}

\item{cols}{a vector of colors, must have length equal to the number of methods used in the simulation}

\item{show.legend}{logical (TRUE/FALSE) for whether a legend should be included in the plot. Default is FALSE}

\item{text.size}{numeric value for the font size}

\item{num.sims}{numeric value for the number of replicates evaluated in each full combination of experimental settings}
}
\value{
graphical display (via ggplot2)
}
\description{
Graphically displays the count of joint ranks selected by each method employed in the simulation study described in the CJIVE manuscript
}
