% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull.R
\name{bi.dist.weibull}
\alias{bi.dist.weibull}
\title{Samples from a Weibull distribution.}
\usage{
bi.dist.weibull(
  scale,
  concentration,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{scale}{A numeric vector, matrix, or array representing the scale parameter of the Weibull distribution. Must be positive.}

\item{concentration}{A numeric vector, matrix, or array representing the shape parameter of the Weibull distribution. Must be positive.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector.  This is used with `.expand(shape)` when `sample=False` (model building) to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Weibull distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Weibull distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Weibull distribution is widely used for modeling **lifetime or reliability data**. Its shape parameter (k) controls the hazard function:
* (k < 1): decreasing hazard (infant mortality)
* (k = 1): constant hazard ??? reduces to **Exponential distribution**
* (k > 1): increasing hazard (aging/failure over time)
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.weibull(scale = c(10, 10), concentration = c(1,1), sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#weibull}
}
