% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Diesel}
\alias{Diesel}
\title{Diesel fuel prices in 1999-2000 in nine regions of the country}
\format{
A data frame/tibble with 650 observations on three variables
\describe{ 
\item{date}{date when price was recorded}
\item{pricepergallon}{price per gallon (in dollars)}
\item{location}{a factor with levels \code{California}, \code{CentralAtlantic},
\code{Coast}, \code{EastCoast}, \code{Gulf}, \code{LowerAtlantic}, \code{NatAvg},
\code{NorthEast}, \code{Rocky}, and \code{WesternMountain}}
}
}
\source{
Energy Information Administration, National Enerfy Information Center:
1000 Independence Ave., SW, Washington, D.C., 20585.
}
\usage{
Diesel
}
\description{
Data for Exercise 2.8
}
\examples{

par(las = 2)
boxplot(pricepergallon ~ location, data = Diesel)
boxplot(pricepergallon ~ location, 
       data = droplevels(Diesel[Diesel$location == "EastCoast" | 
       Diesel$location == "Gulf" | Diesel$location == "NatAvg" | 
       Diesel$location == "Rocky" | Diesel$location == "California", ]), 
       col = "pink", main = "Exercise 2.8")
par(las = 1) 
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Diesel, aes(x = date, y = pricepergallon, 
           color = location)) + 
           geom_point() + 
           geom_smooth(se = FALSE) + 
           theme_bw() + 
           labs(y = "Price per Gallon (in dollars)")
}         
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
