% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.R
\name{contour.bcea}
\alias{contour.bcea}
\alias{contour}
\title{Contour Plots for the Cost-Effectiveness Plane}
\usage{
\method{contour}{bcea}(
  he,
  pos = "topleft",
  graph = c("base", "ggplot2", "plotly"),
  comparison = NULL,
  ...
)

contour(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}.
Not all plotting functions have a \code{"plotly"} implementation yet.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as NULL plots all the comparisons
together. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)} or \code{comparison=2}).}

\item{...}{Additional graphical arguments. The usual ggplot2 syntax is used regardless of graph type.
\itemize{
\item \code{xlim}: The range of the plot along the x-axis. If NULL (default) it is
determined by the range of the simulated values for \code{delta_e}
\item \code{ylim}: The range of the plot along the y-axis. If NULL (default) it is
determined by the range of the simulated values for \code{delta_c}
\item \code{scale}: Scales the plot as a function of the observed standard deviation.
\item \code{levels}: Numeric vector of levels at which to draw contour lines. Quantiles 0<p<1.
\item \code{nlevels}: Number of levels to be plotted in the contour.
}}
}
\value{
\item{ceplane}{ A ggplot object containing the plot. Returned only
if \code{graph="ggplot2"}. } Plots the cost-effectiveness plane with a
scatterplot of all the simulated values from the (posterior) bivariate
distribution of (\eqn{\Delta_e, \Delta_c}), the differentials of effectiveness and
costs; superimposes a contour of the distribution and prints the estimated
value of the probability of each quadrant (combination of positive/negative
values for both \eqn{\Delta_e} and \eqn{\Delta_c})
}
\description{
Contour method for objects in the class \code{bcea}.
Produces a scatterplot of the cost-effectiveness plane, with a contour-plot
of the bivariate density of the differentials of cost (y-axis) and
effectiveness (x-axis).
}
\examples{
data(Vaccine)

# run the health economic evaluation using BCEA
m <- bcea(e=eff,
          c=cost,           # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
      plot=TRUE             # plots the results
)

contour(m)
contour(m, graph = "ggplot2")

contour(m,          # uses the results of the economic evaluation 
                    #  (a "bcea" object)
      comparison=1, # if more than 2 interventions, selects the 
                    #  pairwise comparison 
      nlevels=10,   # selects the number of levels to be 
                    #  plotted (default=4)
      levels=NULL,  # specifies the actual levels to be plotted 
                    #  (default=NULL, so that R will decide)
      scale=1,      # scales the bandwidths for both x- and 
                    #  y-axis (default=0.5)
      graph="base"  # uses base graphics to produce the plot
)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=ceplane.plot]{ceplane.plot()}},
\code{\link[=contour2]{contour2()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
