% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.ddecays}
\alias{Zeta.ddecays}
\title{Zeta distance decay for a range of numbers of assemblages or sites}
\usage{
Zeta.ddecays(xy, data.spec, orders = 2:10, sam = 1000,
  confint.level = 0.95, method = "mean", plot = TRUE)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{orders}{Range of number of assemblages or sites at which zeta diversity is computed. All the orders must be striclty greater than 1.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{confint.level}{Percentage for the confidence intervals of the coefficient from the linear regression.}

\item{method}{Indicates which distance to consider for more than 3 sites. Method can be "\code{mean}" or "\code{max}"}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}
}
\value{
\code{Zeta.ddecays} returns a list containing the following components:

\item{coefs}{A vector of the coefficients from the linear regressions over distance for the numbers of sites specified by 'order'.}

\item{confint}{The confidence intervals for the coefficients from the linear regressions.}
}
\description{
Computes the distance decay of zeta diversity for a range of orders (number of assemblages or sites), using linear regressions.
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]

dev.new()
zeta.ddecays <- Zeta.ddecays(xy, data.spec, sam = 100, orders = 2:5,
    plot = TRUE, confint.level = 0.95)

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]

dev.new()
zeta.ddecays.species <- Zeta.ddecays(xy, data.species, sam = 100, orders = 2:5,
   plot = TRUE, confint.level = 0.95)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.ddecay}}
}

