% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBatsmenPartnershipAllOppnAllMatches.R
\name{teamBatsmenPartnershipAllOppnAllMatches}
\alias{teamBatsmenPartnershipAllOppnAllMatches}
\title{Team batting partnership in all matches all oppositions}
\usage{
teamBatsmenPartnershipAllOppnAllMatches(matches,theTeam,report="summary")
}
\arguments{
\item{matches}{All the matches of the team against all oppositions}

\item{theTeam}{The team for which the the batting partnerships are sought}

\item{report}{if the report="summary" then the data frame returned gives a list of the batsmen with the highest
partnerships. If report="detailed" then the detailed breakup of the partnership is returned.}
}
\value{
partnerships
The data frame with the partnerships
}
\description{
This function computes the batting partnership of a team againt all oppositions in all matches
This function returns a dataframe which is a summary of the batsman with the highest partnerships
or the partnership of an individual batsman
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India against all oppositions
m <-teamBattingScorecardAllOppnAllMatches(matches,theTeam="India")
# Get the  summary report
teamBatsmenPartnershipAllOppnAllMatches(matches,theTeam='India')

# Get the detailed report
teamBatsmenPartnershipAllOppnAllMatches(matches,theTeam='India',report="detailed")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenVsBowlersOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
